%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   MoM-based MATLAB program for a charged cube


clear all; 
close all;
N = 600;
Nside = N/6;
a = 1;
V0 = 1;
EPS0 = 8.8542*10^(-12);
n = sqrt(Nside);

[p,q,dS] = localCoordinates(n,n,a,a);
temp0 = zeros(1,Nside);
temp1 = a*ones (1,Nside);


x = [p,p,p,p,temp0,temp1];
y = [q,q,temp0,temp1,p,p];
z = [temp0,temp1,q,q,q,q];
S = [dS,dS,dS,dS,dS,dS];


%matrix A 
A = matrixA(EPS0,S,x,y,z);

%matrix B

B = V0 * ones(N,1); 

rhos = A\B;  %solving the equation


rhos1side = rhos(1:Nside); 


%making 2D matrix rhos

for i = 1:n
rhos2D(i,:) = rhos1side((i-1)*n +1:i*n);
end;


figure(1);
surf(rhos2D);

colormap('cool');
shading interp;
title('One cube side surface charge distribution');
xlabel('x[m]');
ylabel('y[m]');
zlabel('\rho_s');


figure(2);

imagesc(rhos2D);
colormap('cool');
axis equal;
shading interp;
title('One cube side surface charge distribution');
xlabel('x');
ylabel('y');

%Qtot;

Qtot = totalCharge(S,rhos);
fprintf('\nTotal charge of the cube is %2.3d pC', Qtot*10^12);